// $Id: CMouseEvent.cpp,v 1.4 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CMouseEvent.hpp"
using Exponent::GUI::Events::CMouseEvent;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CMouseEvent, CCountedObject);

//	===========================================================================
CMouseEvent::CMouseEvent(CMouse *mouse, const EMouseEventType type, double wheelMovementAmount)
		   : m_type(type)
		   , m_mouse(mouse)
		   , m_wheelMovementAmount(wheelMovementAmount)
		   , m_shiftIsDown(false)
		   , m_altIsDown(false)
		   , m_ctrlIsDown(false)
		#ifdef WIN32
		   , m_rawModifiers(0)
		#endif
{
	EXPONENT_CLASS_CONSTRUCTION(CMouseEvent);
	m_type = type;
	m_wheelMovementAmount = wheelMovementAmount;
	m_mouse = mouse;
	this->setModifiers(false, false, false);
	#ifdef WIN32
		m_rawModifiers = 0;
	#endif
}

//	===========================================================================
#ifdef WIN32
CMouseEvent::CMouseEvent(CMouse *mouse, const UINT type, double wheelMovementAmount)
		   : m_type(e_mouseMove)
		   , m_mouse(mouse)
		   , m_wheelMovementAmount(wheelMovementAmount)
		   , m_shiftIsDown(false)
		   , m_altIsDown(false)
		   , m_ctrlIsDown(false)
		   , m_rawModifiers(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CMouseEvent);
	switch(type)
	{
		case WM_LBUTTONDOWN:	m_type = e_leftMouseDown;			break;
		case WM_RBUTTONDOWN:	m_type = e_rightMouseDown;			break;
		case WM_LBUTTONUP:		m_type = e_leftMouseUp;				break;
		case WM_RBUTTONUP:		m_type = e_rightMouseUp;			break;
		case WM_LBUTTONDBLCLK:	m_type = e_leftMouseDoubleClick;	break;
		case WM_MOUSEWHEEL:		m_type = e_mouseWheelMove;			break;
		case WM_MOUSEMOVE:		m_type = e_mouseMove;				break;
		case WM_MOUSELEAVE:		m_type = e_mouseLeftArea;			break;
	}
	m_wheelMovementAmount = wheelMovementAmount;
	m_mouse = mouse;
	this->setModifiers(false, false, false);
	m_rawModifiers = 0;
}
#endif

//	===========================================================================
CMouseEvent::~CMouseEvent()
{
	EXPONENT_CLASS_DESTRUCTION(CMouseEvent);
}

//	===========================================================================
void CMouseEvent::setWheelMovementAmount(const double wheelMovementAmount) 
{ 
	m_wheelMovementAmount = wheelMovementAmount; 
}

//	===========================================================================
double CMouseEvent::getWheelMovementAmount() const 
{ 
	return m_wheelMovementAmount; 
}

//	===========================================================================
void CMouseEvent::setEventType(EMouseEventType type) 
{
	m_type = type;
}

//	===========================================================================
CMouseEvent::EMouseEventType CMouseEvent::getEventType() const 
{ 
	return m_type; 
}

//	===========================================================================
const CMouse *CMouseEvent::getMouse() const 
{ 
	return m_mouse; 
}

//	===========================================================================
CMouse *CMouseEvent::getMutableMouse() const 
{ 
	return m_mouse; 
}

//	===========================================================================
void CMouseEvent::setModifiers(const bool ctrl, const bool shift, const bool alt)
{
	m_ctrlIsDown = ctrl;
	m_shiftIsDown = shift;
	m_altIsDown = alt;
}

//	===========================================================================
#ifdef WIN32
void CMouseEvent::setModifiers(WPARAM wParam)
{
	m_rawModifiers = wParam;
}

//	===========================================================================
WPARAM CMouseEvent::getModifiers() const { return m_rawModifiers; }
#endif

//	===========================================================================
bool CMouseEvent::isCtrlDown() const 
{ 
	return m_ctrlIsDown; 
}

//	===========================================================================
bool CMouseEvent::isShiftDown() const 
{ 
	return m_shiftIsDown; 
}

//	===========================================================================
bool CMouseEvent::isAltDown() const 
{ 
	return m_altIsDown;
}

//	===========================================================================
void CMouseEvent::setMousePosition(const CPoint &point) 
{ 
	m_mouse->setPosition(point); 
}

//	===========================================================================
const CPoint &CMouseEvent::getMousePosition() const 
{ 
	return m_mouse->getPosition(); 
}